/*
 * Decompiled with CFR 0.152.
 */
package com.sync.syncman.rpc;

import com.sync.io.ByteArrayOutputStreamEx;
import com.sync.syncman.rpc.RPCParm;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Vector;

public class RPCClient {
    static final int STATUS_OK = 0;
    static final int STATUS_BAD_OPCODE = -1;
    static final int STATUS_BAD_ARGS = -2;
    static final int STATUS_GENERAL_ERROR = -3;
    private Socket sock;
    private ByteArrayOutputStreamEx byteOut;
    private DataOutputStream marshalStream;
    private DataInputStream unmarshalStream;

    public RPCClient(int n) {
        try {
            this.sock = new Socket("127.0.0.1", n);
            this.byteOut = new ByteArrayOutputStreamEx(1024);
            this.marshalStream = new DataOutputStream(this.byteOut);
            this.unmarshalStream = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 1024));
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception + '\n');
            return;
        }
    }

    public synchronized int invoke(int n, Vector vector) {
        int n2;
        try {
            RPCParm rPCParm;
            this.byteOut.reset();
            this.marshalStream.writeInt(0);
            this.marshalStream.writeInt(n);
            int n3 = 0;
            while (n3 < vector.size()) {
                rPCParm = (RPCParm)vector.elementAt(n3);
                if (rPCParm.isInput()) {
                    rPCParm.marshal(this.marshalStream);
                }
                ++n3;
            }
            this.byteOut.pokeInt(0, this.byteOut.size() - 4);
            this.byteOut.writeTo(this.sock.getOutputStream());
            this.sock.getOutputStream().flush();
            int n4 = this.unmarshalStream.readInt();
            n2 = this.unmarshalStream.readInt();
            if (n2 == 0) {
                n3 = 0;
                while (n3 < vector.size()) {
                    rPCParm = (RPCParm)vector.elementAt(n3);
                    if (rPCParm.isOutput()) {
                        rPCParm.unmarshal(this.unmarshalStream);
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            n2 = -3;
            System.out.println("Exception: " + exception + '\n');
        }
        return n2;
    }
}

